/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package gestionnairevente;

import java.awt.BorderLayout;
import javax.swing.table.AbstractTableModel;

/**
 * 
 * Fenêtre d'accueil de l'application de gestion d'un magasin
 *
 * @author Charles
 */
public class GestionnaireVenteJFrame extends javax.swing.JFrame {
    
    public int stockBiscuit;
    public int stockGateau;
    public int prixBiscuit;
    public int prixGateau;
    public int venteTotal;

    /**
     * Creates new form GestionnaireJFrame
     */
    public GestionnaireVenteJFrame() {
        initComponents();
        
        this.add(jPanel1, BorderLayout.NORTH);
        this.add(jPanel3, BorderLayout.CENTER);
        this.add(jPanel2, BorderLayout.SOUTH);
        
        jTable1.setModel(new AbstractTableModel() {

            @Override
            public String getColumnName(int column) {
                                
                if(column == 0) {
                    return "Produit";
                } else if(column == 1) {
                    return "Quantite";
                } else {
                    return "Prix";
                }
                
            }

            @Override
            public int getRowCount() {
                return 2;
            }

            @Override
            public int getColumnCount() {
                return 3;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                
                if(columnIndex == 0) {
                    
                    if(rowIndex == 0) {
                        return "Biscuit";
                    } else if(rowIndex == 1) {
                        return "Gateau";
                    } else {
                        return "Prix";
                    }
                    
                } else if (columnIndex == 1) {
                    
                    if(rowIndex == 0) {
                        return stockBiscuit;
                    } else {
                        return stockGateau;
                    }
                    
                } else {
                    
                    if(rowIndex == 0) {
                        return prixBiscuit;
                    } else {
                        return prixGateau;
                    }
                }
            }
        });
      
        
        
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jTextField1 = new javax.swing.JTextField();
        jPanel3 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Actions"));
        jPanel1.setMaximumSize(new java.awt.Dimension(32767, 100));
        jPanel1.setMinimumSize(new java.awt.Dimension(297, 153));
        jPanel1.setPreferredSize(new java.awt.Dimension(719, 100));
        java.awt.FlowLayout flowLayout1 = new java.awt.FlowLayout(java.awt.FlowLayout.CENTER, 5, 0);
        flowLayout1.setAlignOnBaseline(true);
        jPanel1.setLayout(flowLayout1);

        jButton1.setText("Gestion stock");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });
        jPanel1.add(jButton1);

        jButton2.setText("Faire une vente");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });
        jPanel1.add(jButton2);

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Chiffre d'affaire"));
        jPanel2.setMaximumSize(new java.awt.Dimension(32767, 200));
        jPanel2.setMinimumSize(new java.awt.Dimension(101, 143));
        jPanel2.setPreferredSize(new java.awt.Dimension(719, 154));
        jPanel2.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.CENTER, 5, 0));

        jLabel1.setText("Vente Totale :");
        jPanel2.add(jLabel1);

        jTextField1.setEditable(false);
        jTextField1.setColumns(10);
        jPanel2.add(jTextField1);

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("Stock courant"));
        jPanel3.setPreferredSize(new java.awt.Dimension(719, 277));

        jScrollPane1.setPreferredSize(new java.awt.Dimension(452, 202));

        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jScrollPane1.setViewportView(jTable1);

        jPanel3.add(jScrollPane1);

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        getContentPane().setLayout(new javax.swing.BoxLayout(getContentPane(), javax.swing.BoxLayout.Y_AXIS));

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        new GestionStockJDialog(this, rootPaneCheckingEnabled).setVisible(true);
    }//GEN-LAST:event_jButton1ActionPerformed

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        
        new VenteJDialog(this, rootPaneCheckingEnabled).setVisible(true);

    }//GEN-LAST:event_jButton2ActionPerformed
    
    /*
    * Méthode permettant de mettre à jour le tableau et le total des ventes
    */
    public void mettreAJour() {
        
        jTextField1.setText(Integer.toString(venteTotal));
        jTable1.updateUI();
        
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTable1;
    private javax.swing.JTextField jTextField1;
    // End of variables declaration//GEN-END:variables
}
