/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package exercicepratiquecomposite;

import java.awt.Container;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JLabel;

/**
 *
 * @author Charles
 */
public class Mot implements MotComponent {
    
    ArrayList<MotComponent> components = new ArrayList<MotComponent>();
    
    protected JLabel terme;
    protected String texte;
    protected int size;
    protected String rgb;
        
    public Mot(Container panel, String texte) {
        this.terme = new JLabel();
        this.texte = texte;
        this.size = getRandomBetween(1, 10);
        this.rgb = "rgb(" + 
                getRandomBetween(0, 255) + "," + getRandomBetween(0, 255) + "," + getRandomBetween(0, 255) + ")";
        
        terme.setText("<html><font size='" + size + "' color='"+ rgb +"'>" + texte + "</font></html>");
              
        terme.setBounds(getRandomBetween(0, 500), getRandomBetween(0, 500), 200, 100);
        panel.add(terme);
        
    }
        
    private int getRandomBetween (int low, int high) {
        Random r = new Random();

        return r.nextInt(Math.abs(high-low)) + low;    
    }

    @Override
    public void augmenterTaille() {
        size++;
        terme.setText("<html><font size='" + size + "' color='"+ rgb +"'>" + texte + "</font></html>");
        
        for(MotComponent component : components) {
            component.augmenterTaille();
        }
    }

    @Override
    public void diminuerTaille() {    
        size--;
        terme.setText("<html><font size='" + size + "' color='"+ rgb +"'>" + texte + "</font></html>");
        
        for(MotComponent component : components) {
            component.diminuerTaille();
        }
    }

    @Override
    public void changerCouleur() {
        this.rgb = "rgb(" + 
                getRandomBetween(0, 255) + "," + getRandomBetween(0, 255) + "," + getRandomBetween(0, 255) + ")";
        terme.setText("<html><font size='" + size + "' color='"+ rgb +"'>" + texte + "</font></html>");
        
        for(MotComponent component : components) {
            component.changerCouleur();
        }
    }
    
    public void ajouterComponent(MotComponent component) {
        components.add(component);
    }
    
    public void removeComponent(MotComponent component) {
        components.remove(component);
    }
    
}
