/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package exercicecomposite;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/**
 *
 * @author Charles
 */
public class MachineComposite implements MachineComponent, ActionListener, ChangeListener {
    
    ArrayList<MachineComponent> components = new ArrayList<MachineComponent>();
    
    JComponent component;
    
    boolean state = false;
    
    public MachineComposite(JComponent component) {
        this.component = component;
    }
    
    @Override
    public void actionOn() {
        
        component.setEnabled(true);
        
        //Si l'état du JToggle button est à appuyé alors rendre les boutons dépendant accessible (enabled).
        if(state) {
            for(MachineComponent component : components) {
                component.actionOn();
            }
        }
    }

    @Override
    public void actionOff() {
               
        component.setEnabled(false);
        
        for(MachineComponent component : components) {
                component.actionOff();
        }        
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        //Inverser l'état
        state = !state;
                
        if(state) {
            actionOn();
        } else {
            actionOff();
        }
    }
    
    public void addComponent(MachineComponent c) {
        components.add(c);
    }
    
    public void removeComponent(MachineComponent c) {
        components.remove(c);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        
        JSlider slider = (JSlider) e.getSource();
                
        //Inverser l'état à partir de la valeur du JSlider
        state = (slider.getValue() != 0);
                
        if(state) {
            actionOn();
        } else {
            actionOff();
        }
        
       //Overide le setEnabled false destiné aux JToggleButton 
       slider.setEnabled(true);
    }
    
}
